<?php
   $fundee_redux_demo = get_option('redux_demo');
   get_header('home1'); 
?>
<?php 
    while (have_posts()): the_post();
    $single_audio = get_post_meta(get_the_ID(),'_cmb_single_audio', true);
    $single_video = get_post_meta(get_the_ID(),'_cmb_single_video', true);
?>
<?php if(isset($fundee_redux_demo['blog_single_image']['url']) && $fundee_redux_demo['blog_single_image']['url'] != ''){?> 
<div class="breadcrumb-area pt-150 pb-155" style="background-image:url(<?php echo htmlspecialchars_decode(esc_attr($fundee_redux_demo['blog_single_image']));?>)">
<?php }else{?>
<div class="breadcrumb-area pt-150 pb-155" style="background-image:url(<?php echo get_template_directory_uri();?>/assets/img/bg/bg-13.jpg)">
<?php } ?>
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="breadcrumb-text text-center">
                    <h1>
                        <?php if(isset($fundee_redux_demo['blog_single_title'])){?>
                        <?php echo htmlspecialchars_decode(esc_attr($fundee_redux_demo['blog_single_title']));?>
                        <?php }else{?>
                        <?php echo esc_html__( 'Blog details', 'fundee' ); } ?>
                    </h1>
                    <ul class="breadcrumb-menu">
                        <li><a href="<?php echo esc_url(home_url('/')); ?>">
                                <?php echo esc_html__( 'Home', 'fundee' );?>
                            </a>
                        </li>
                        <li>
                            <span>
                                <?php if(isset($fundee_redux_demo['blog_single_title'])){?>
                                <?php echo htmlspecialchars_decode(esc_attr($fundee_redux_demo['blog_single_title']));?>
                                <?php }else{?>
                                <?php echo esc_html__( 'Blog details', 'fundee' ); } ?>
                            </span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- breadcrumb-area-end -->

<!-- blog-area-start -->
<div class="blog-grid-area pt-130 pb-100">
    <div class="container">
        <div class="row">
            <div class="col-xl-8 col-lg-8 mb-30">
                <div class="blog-details-wrapper blog-standard">
                    <?php if ( has_post_format('video') ) { ?>
                        <div class="blog-img  pos-rel">
                            <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="">
                            <div class="blog-video-icon">
                                <a class="popup-video" href="<?php echo esc_url($single_video);?>"><i class="fas fa-play"></i></a>
                            </div>
                        </div>
                    <?php } elseif ( has_post_format('gallery') ) { ?>
                        <div class="postbox__gallery">
                            <?php $gallery = get_post_gallery( get_the_ID(), false );
                            if(isset($gallery['ids'])){    
                                $gallery_ids = $gallery['ids'];
                                $img_ids = explode(",",$gallery_ids);
                                $i=0; $j=0;?>
                                <?php   
                                foreach( $img_ids AS $img_id ){ 
                                    $image_src = wp_get_attachment_image_src($img_id,''); 
                                    ?>
                                    <img src="<?php echo esc_url($image_src[0]); ?>" alt="blog image">
                            <?php } } ?>
                        </div>
                    <?php } elseif ( has_post_format('audio') ) { ?>
                        <div class="postbox__audio embed-responsive embed-responsive-16by9 mb-30">
                            <iframe src="https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/666328004&color=%23ff5500&auto_play=false&hide_related=false&show_comments=true&show_user=true&show_reposts=false&show_teaser=true&visual=true"></iframe>
                        </div>
                    <?php } elseif ( has_post_thumbnail() ) { ?>
                        <?php if (get_post_thumbnail_id() !='')  { ?>
                        <div class="blog-img">
                            <img src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" alt="">
                        </div>
                        <?php } ?>
                    <?php } ?>

                    <div class="blog-content blog-02-content">
                        <div class="blog-meta">
                            <span><i class="far fa-calendar-alt"></i> <?php the_time(get_option( 'date_format' ));?></span>
                            <span><i class="far fa-comment"></i> <?php comments_number( esc_html__('0 Comments', 'moral'), esc_html__('1 Comment', 'moral'), esc_html__('% Comments', 'moral') ); ?></span>
                        </div>
                        <div class="blog-title">
                            <h3><?php the_title(); ?></h3>
                        </div>
                        <?php the_content(); ?>
                        <?php wp_link_pages( array(
                            'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'webfix' ),
                            'after'       => '</div>',
                            'link_before' => '<p class="page-number">',
                            'link_after'  => '</p>',
                        ) ); ?>
                    </div>
                    
                    <?php comments_template();?>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 mb-30">
                <div class="blog-sidebar">
                    <?php get_sidebar();?>  
                </div>
            </div>
        </div>
    </div>
</div>
<?php endwhile; ?>
    <!-- FOOTER -->
<?php
    get_footer();
?>

