<?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains comments and the comment form.
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
if ( post_password_required() )
    return;
?>

<?php if ( have_comments() ) : ?>
<div class="post-comments">
    <div class="blog-coment-title mb-30">
        <h2><?php echo esc_html('Comments', 'fundee');?> (<?php comments_number( esc_html__(' 0 ', 'moral'), esc_html__(' 1 ', 'moral'), esc_html__('%', 'moral') ); ?>)</h2>
    </div>
    <div class="latest-comments">
        <ul>
        <?php wp_list_comments('callback=fundee_theme_comment'); ?>
        </ul>
    </div>
</div>

<div class="col-md-12"> 
<!-- START PAGINATION -->
<?php
if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
?>
<div class="pagination_area">
     <nav>
          <ul class="pagination">
               <li> <?php paginate_comments_links( 
              array(
              'prev_text' => wp_specialchars_decode(esc_html__( '<i class="fa fa-angle-left"></i>', 'fundee' ),ENT_QUOTES),
              'next_text' => wp_specialchars_decode(esc_html__( '<i class="fa fa-angle-right"></i>', 'fundee' ),ENT_QUOTES),
              ));  ?>
                </li>
          </ul>
     </nav>
</div>                                       
<?php endif; ?>
<!-- END PAGINATION --> 
</div>
<?php endif; ?>     
<?php
    if ( is_singular() ) wp_enqueue_script( "comment-reply" );
$aria_req = ( $req ? " aria-required='true'" : '' );
$comment_args = array(
        'id_form' => 'contacts-form',        
        'class_form' => 'conatct-post-form',                         
        'title_reply'=> wp_specialchars_decode(esc_html__( 'Leave A Comment', 'fundee' ),ENT_QUOTES),
        'fields' => apply_filters( 'comment_form_default_fields', array(
              
             'author' => '
             <div class="col-xl-12 dc241">
             <div class="contact-icon contacts-name">
                          <input type="text" name="author" placeholder="'.esc_attr__('Your Name.... ', 'fundee').'" required="'.esc_attr__('required', 'fundee').'" data-error="'.esc_attr__('Name is required.', 'fundee').'">
                          </div></div>',
            'email' => '<div class="col-xl-12 dc241">
                        <div class="contact-icon contacts-email">
                             <input type="email" name="email" placeholder="'.esc_attr__('Your Email....', 'fundee').'" required="'.esc_attr__('required', 'fundee').'" data-error="'.esc_attr__('Valid email is required.', 'fundee').'">
                             <div class="help-block with-errors"></div>
                        </div>
                        </div>',
            'Website' => '<div class="col-xl-12 dc241">
                            <div class="contact-icon contacts-website">
                             <input type="text" name="Website" placeholder="'.esc_attr__('Your Website....', 'fundee').'" required="'.esc_attr__('required', 'fundee').'" data-error="'.esc_attr__('Valid email is required.', 'fundee').'">
                             <div class="help-block with-errors"></div>
                          </div>
                        </div>',
        ) ),   
          'comment_field' => '<div class="col-xl-12 dc241">
                                <div class="contact-icon contacts-message">
                                <textarea id="message"  name="comment" placeholder="'.esc_attr__('Write A Comment', 'fundee').'" required="'.esc_attr__('required', 'fundee').'" data-error="'.esc_attr__('Please,leave us a message.', 'fundee').'"></textarea>
                                  <div class="help-block with-errors"></div>
                              </div>
                              </div>
                              ', 
                
         'label_submit' => esc_html__( 'Post A Comment', 'fundee' ),
         'comment_notes_before' => '',
         'comment_notes_after' => '',               
)
?>
<div class="post-comments-form">
<?php if ( comments_open() ) : ?>
    <?php comment_form($comment_args); ?>
<?php endif; ?> 
</div>