<?php
/**
 * The "Style 2" template to display the post header of the single post or attachment:
 * featured image and title placed in the post header
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.75.0
 */

if ( apply_filters( 'faithful_filter_single_post_header', faithful_is_singular( 'post' ) || faithful_is_singular( 'attachment' ) ) ) {
	$faithful_post_format = str_replace( 'post-format-', '', get_post_format() );

	// Featured image
	ob_start();
	faithful_show_post_featured_image( array(
		'thumb_bg'  => true,
	) );
	$faithful_post_header = ob_get_contents();
	ob_end_clean();

	$faithful_with_featured_image = faithful_is_with_featured_image( $faithful_post_header );

	// Post title and meta
	ob_start();
	faithful_show_post_title_and_meta( array(
										'content_wrap'  => true,
										'share_type'    => 'list',
										'show_labels'   => true,
										'author_avatar' => false,
										'add_spaces'    => false,
										'cat_sep' 	    => false,
										)
									);
	$faithful_post_header .= ob_get_contents();
	ob_end_clean();

	if ( strpos( $faithful_post_header, 'post_featured' ) !== false
		|| strpos( $faithful_post_header, 'post_title' ) !== false
		|| strpos( $faithful_post_header, 'post_meta' ) !== false
	) {
		?>
		<div class="post_header_wrap post_header_wrap_in_header post_header_wrap_style_<?php
			echo esc_attr( faithful_get_theme_option( 'single_style' ) );
			if ( $faithful_with_featured_image ) {
				echo ' with_featured_image';
			}
		?>">
			<?php
			do_action( 'faithful_action_before_post_header' );
			faithful_show_layout( $faithful_post_header );
			do_action( 'faithful_action_after_post_header' );
			?>
		</div>
		<?php
	}
}
