<?php
/**
 * The default template to displaying related posts
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.0.54
 */

$faithful_link        = get_permalink();
$faithful_post_format = get_post_format();
$faithful_post_format = empty( $faithful_post_format ) ? 'standard' : str_replace( 'post-format-', '', $faithful_post_format );
?><div id="post-<?php the_ID(); ?>" <?php post_class( 'related_item post_format_' . esc_attr( $faithful_post_format ) ); ?> data-post-id="<?php the_ID(); ?>">
	<?php
	faithful_show_post_featured(
		array(
			'thumb_size' => apply_filters( 'faithful_filter_related_thumb_size', faithful_get_thumb_size(
				(int) faithful_get_theme_option( 'related_posts' ) == 1 || (int) faithful_get_theme_option( 'related_columns' ) == 1 ? 'full' : 'big' )
			),
		)
	);
	?>
	<div class="post_header entry-header">
		<h6 class="post_title entry-title"><a href="<?php echo esc_url( $faithful_link ); ?>"><?php
			if ( '' == get_the_title() ) {
				esc_html_e( 'No title', 'faithful' );
			} else {
				the_title();
			}
		?></a></h6>
		<?php
		if ( in_array( get_post_type(), array( 'post', 'attachment' ) ) ) {
			?>
			<span class="post_date"><a href="<?php echo esc_url( $faithful_link ); ?>"><?php echo wp_kses_data( faithful_get_date() ); ?></a></span>
			<?php
		}
		?>
	</div>
</div>
