<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.0
 */

// Page (category, tag, archive, author) title

if ( faithful_need_page_title() ) {
	faithful_sc_layouts_showed( 'title', true );
	?>
	<div class="top_panel_title sc_layouts_row">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Blog/Page title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$faithful_blog_title           = faithful_get_blog_title();
							$faithful_blog_title_text      = '';
							$faithful_blog_title_class     = '';
							$faithful_blog_title_link      = '';
							$faithful_blog_title_link_text = '';
							if ( is_array( $faithful_blog_title ) ) {
								$faithful_blog_title_text      = $faithful_blog_title['text'];
								$faithful_blog_title_class     = ! empty( $faithful_blog_title['class'] ) ? ' ' . $faithful_blog_title['class'] : '';
								$faithful_blog_title_link      = ! empty( $faithful_blog_title['link'] ) ? $faithful_blog_title['link'] : '';
								$faithful_blog_title_link_text = ! empty( $faithful_blog_title['link_text'] ) ? $faithful_blog_title['link_text'] : '';
							} else {
								$faithful_blog_title_text = $faithful_blog_title;
							}
							?>
							<h1 class="sc_layouts_title_caption<?php echo esc_attr( $faithful_blog_title_class ); ?>"<?php
								if ( faithful_is_on( faithful_get_theme_option( 'seo_snippets' ) ) ) {
									?> itemprop="headline"<?php
								}
							?>>
								<?php
								$faithful_top_icon = faithful_get_term_image_small();
								if ( ! empty( $faithful_top_icon ) ) {
									$faithful_attr = faithful_getimagesize( $faithful_top_icon );
									?>
									<img src="<?php echo esc_url( $faithful_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'faithful' ); ?>"
										<?php
										if ( ! empty( $faithful_attr[3] ) ) {
											faithful_show_layout( $faithful_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $faithful_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $faithful_blog_title_link ) && ! empty( $faithful_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $faithful_blog_title_link ); ?>" class="theme_button sc_layouts_title_link"><?php echo esc_html( $faithful_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'faithful_action_breadcrumbs' );
						$faithful_breadcrumbs = ob_get_contents();
						ob_end_clean();
						faithful_show_layout( $faithful_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
