<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.0
 */

$faithful_args = get_query_var( 'faithful_logo_args' );

// Site logo
$faithful_logo_type   = isset( $faithful_args['type'] ) ? $faithful_args['type'] : '';
$faithful_logo_image  = faithful_get_logo_image( $faithful_logo_type );
$faithful_logo_text   = faithful_is_on( faithful_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$faithful_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $faithful_logo_image['logo'] ) || ! empty( $faithful_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $faithful_logo_image['logo'] ) ) {
			if ( empty( $faithful_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric( $faithful_logo_image['logo'] ) && (int) $faithful_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$faithful_attr = faithful_getimagesize( $faithful_logo_image['logo'] );
				echo '<img src="' . esc_url( $faithful_logo_image['logo'] ) . '"'
						. ( ! empty( $faithful_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $faithful_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $faithful_logo_text ) . '"'
						. ( ! empty( $faithful_attr[3] ) ? ' ' . wp_kses_data( $faithful_attr[3] ) : '' )
						. '>';
			}
		} else {
			faithful_show_layout( faithful_prepare_macros( $faithful_logo_text ), '<span class="logo_text">', '</span>' );
			faithful_show_layout( faithful_prepare_macros( $faithful_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
