<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
				<?php
					$faithful_copyright = faithful_get_theme_option( 'copyright' );
					if ( ! empty( $faithful_copyright ) ) {
						// Replace {{Y}} or {Y} with the current year
						$faithful_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $faithful_copyright );
						// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
						$faithful_copyright = faithful_prepare_macros( $faithful_copyright );
						// Display copyright
						echo wp_kses( nl2br( $faithful_copyright ), 'faithful_kses_content' );
					}
				?>
			</div>
		</div>
	</div>
</div>