<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.0
 */

$faithful_template_args = get_query_var( 'faithful_template_args' );

if ( is_array( $faithful_template_args ) ) {
	$faithful_columns       = empty( $faithful_template_args['columns'] ) ? 1 : max( 1, $faithful_template_args['columns'] );
	$faithful_blog_style    = array( $faithful_template_args['type'], $faithful_columns );
	$faithful_columns_class = faithful_get_column_class( 1, $faithful_columns, ! empty( $faithful_template_args['columns_tablet']) ? $faithful_template_args['columns_tablet'] : '', ! empty($faithful_template_args['columns_mobile']) ? $faithful_template_args['columns_mobile'] : '' );
} else {
	$faithful_template_args = array();
	$faithful_blog_style    = explode( '_', faithful_get_theme_option( 'blog_style' ) );
	$faithful_columns       = empty( $faithful_blog_style[1] ) ? 1 : max( 1, $faithful_blog_style[1] );
	$faithful_columns_class = faithful_get_column_class( 1, $faithful_columns );
}
$faithful_expanded   = ! faithful_sidebar_present() && faithful_get_theme_option( 'expand_content' ) == 'expand';

$faithful_post_format = get_post_format();
$faithful_post_format = empty( $faithful_post_format ) ? 'standard' : str_replace( 'post-format-', '', $faithful_post_format );

?><div class="<?php
	if ( ! empty( $faithful_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( faithful_is_blog_style_use_masonry( $faithful_blog_style[0] )
			? 'masonry_item masonry_item-1_' . esc_attr( $faithful_columns )
			: esc_attr( $faithful_columns_class )
			);
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $faithful_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $faithful_columns )
				. ' post_layout_' . esc_attr( $faithful_blog_style[0] )
				. ' post_layout_' . esc_attr( $faithful_blog_style[0] ) . '_' . esc_attr( $faithful_columns )
	);
	faithful_add_blog_animation( $faithful_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	$faithful_hover      = ! empty( $faithful_template_args['hover'] ) && ! faithful_is_inherit( $faithful_template_args['hover'] )
							? $faithful_template_args['hover']
							: faithful_get_theme_option( 'image_hover' );

	$faithful_components = ! empty( $faithful_template_args['meta_parts'] )
							? ( is_array( $faithful_template_args['meta_parts'] )
								? $faithful_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $faithful_template_args['meta_parts'] ) )
								)
							: faithful_array_get_keys_by_value( faithful_get_theme_option( 'meta_parts' ) );

	faithful_show_post_featured( apply_filters( 'faithful_filter_args_featured',
		array(
			'thumb_size' => ! empty( $faithful_template_args['thumb_size'] )
								? $faithful_template_args['thumb_size']
								: faithful_get_thumb_size(
									strpos( faithful_get_theme_option( 'body_style' ), 'full' ) !== false
										? ( $faithful_columns > 2 ? 'big' : 'full' )
										: ( $faithful_columns > 2
											? 'med'
											: ( $faithful_expanded || $faithful_columns == 1 ? 
												( $faithful_expanded && $faithful_columns == 1 ? 'huge' : 'big' ) 
												: 'med' 
												)
											)												
								),
			'hover'      => $faithful_hover,
			'meta_parts' => $faithful_components,
			'no_links'   => ! empty( $faithful_template_args['no_links'] ),
		),
		'content-classic',
		$faithful_template_args
	) );

	// Title and post meta
	$faithful_show_title = get_the_title() != '';
	$faithful_show_meta  = count( $faithful_components ) > 0;

	if ( $faithful_show_title ) {
		?><div class="post_header entry-header"><?php
			// Categories
			if ( apply_filters( 'faithful_filter_show_blog_categories', $faithful_show_meta && in_array( 'categories', $faithful_components ), array( 'categories' ), 'classic' ) ) {
				do_action( 'faithful_action_before_post_category' );
				?><div class="post_category"><?php
					faithful_show_post_meta( apply_filters(
														'faithful_filter_post_meta_args',
														array(
															'components' => 'categories',
															'seo'        => false,
															'echo'       => true,
															),
														'hover_' . $faithful_hover, 1
														)
										);
				?></div><?php
				$faithful_components = faithful_array_delete_by_value( $faithful_components, 'categories' );
				do_action( 'faithful_action_after_post_category' );
			}
			// Post title
			if ( apply_filters( 'faithful_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'faithful_action_before_post_title' );
				if ( empty( $faithful_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'faithful_action_after_post_title' );
			}
		?></div><?php
	}
	
	// Post meta
	if ( apply_filters( 'faithful_filter_show_blog_meta', $faithful_show_meta, $faithful_components, 'classic' ) ) {
		if ( count( $faithful_components ) > 0 ) {
			do_action( 'faithful_action_before_post_meta' );
			faithful_show_post_meta(
				apply_filters(
					'faithful_filter_post_meta_args', array(
						'components' => join( ',', $faithful_components ),
						'seo'        => false,
						'echo'       => true,
						'author_avatar' => false,
					), $faithful_blog_style[0], $faithful_columns
				)
			);
			do_action( 'faithful_action_after_post_meta' );
		}
	}

	// Post content
	ob_start();
	if ( apply_filters( 'faithful_filter_show_blog_excerpt', ( ! isset( $faithful_template_args['hide_excerpt'] ) || (int)$faithful_template_args['hide_excerpt'] == 0 ) && (int)faithful_get_theme_option( 'excerpt_length' ) > 0, 'classic' ) ) {
		faithful_show_post_content( $faithful_template_args, '<div class="post_content_inner">', '</div>' );
	}
	$faithful_content = ob_get_contents();
	ob_end_clean();

	faithful_show_layout( $faithful_content, '<div class="post_content entry-content">', '</div>' );

		
	// More button
	if ( apply_filters( 'faithful_filter_show_blog_readmore', ! $faithful_show_title || ! empty( $faithful_template_args['more_button'] ), 'classic' ) ) {
		if ( empty( $faithful_template_args['no_links'] ) ) {
			do_action( 'faithful_action_before_post_readmore' );
			faithful_show_post_more_link( $faithful_template_args, '<p>', '</p>' );
			do_action( 'faithful_action_after_post_readmore' );
		}
	}

	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
