<?php
/**
 * The template to display single post
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.0
 */

// Full post loading
$full_post_loading          = faithful_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = faithful_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = faithful_get_theme_option( 'posts_navigation_scroll_which_block', 'article' );

// Position of the related posts
$faithful_related_position   = faithful_get_theme_option( 'related_position', 'below_content' );

// Type of the prev/next post navigation
$faithful_posts_navigation   = faithful_get_theme_option( 'posts_navigation' );
$faithful_prev_post          = false;
$faithful_prev_post_same_cat = (int)faithful_get_theme_option( 'posts_navigation_scroll_same_cat', 1 );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( faithful_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	faithful_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'faithful_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $faithful_posts_navigation ) {
		$faithful_prev_post = get_previous_post( $faithful_prev_post_same_cat );  // Get post from same category
		if ( ! $faithful_prev_post && $faithful_prev_post_same_cat ) {
			$faithful_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $faithful_prev_post ) {
			$faithful_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $faithful_prev_post ) ) {
		faithful_sc_layouts_showed( 'featured', false );
		faithful_sc_layouts_showed( 'title', false );
		faithful_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $faithful_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'faithful_filter_get_template_part', 'templates/content', 'single-' . faithful_get_theme_option( 'single_style' ) ), 'single-' . faithful_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $faithful_related_position, 'inside' ) === 0 ) {
		$faithful_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'faithful_action_related_posts' );
		$faithful_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $faithful_related_content ) ) {
			$faithful_related_position_inside = max( 0, min( 9, faithful_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $faithful_related_position_inside ) {
				$faithful_related_position_inside = mt_rand( 1, 9 );
			}

			$faithful_p_number         = 0;
			$faithful_related_inserted = false;
			$faithful_in_block         = false;
			$faithful_content_start    = strpos( $faithful_content, '<div class="post_content' );
			$faithful_content_end      = strrpos( $faithful_content, '</div>' );

			for ( $i = max( 0, $faithful_content_start ); $i < min( strlen( $faithful_content ) - 3, $faithful_content_end ); $i++ ) {
				if ( $faithful_content[ $i ] != '<' ) {
					continue;
				}
				if ( $faithful_in_block ) {
					if ( strtolower( substr( $faithful_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$faithful_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $faithful_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $faithful_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$faithful_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $faithful_content[ $i + 1 ] && in_array( $faithful_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$faithful_p_number++;
					if ( $faithful_related_position_inside == $faithful_p_number ) {
						$faithful_related_inserted = true;
						$faithful_content = ( $i > 0 ? substr( $faithful_content, 0, $i ) : '' )
											. $faithful_related_content
											. substr( $faithful_content, $i );
					}
				}
			}
			if ( ! $faithful_related_inserted ) {
				if ( $faithful_content_end > 0 ) {
					$faithful_content = substr( $faithful_content, 0, $faithful_content_end ) . $faithful_related_content . substr( $faithful_content, $faithful_content_end );
				} else {
					$faithful_content .= $faithful_related_content;
				}
			}
		}

		faithful_show_layout( $faithful_content );
	}

	// Comments
	do_action( 'faithful_action_before_comments' );
	comments_template();
	do_action( 'faithful_action_after_comments' );

	// Related posts
	if ( 'below_content' == $faithful_related_position
		&& ( 'scroll' != $faithful_posts_navigation || (int)faithful_get_theme_option( 'posts_navigation_scroll_hide_related', 0 ) == 0 )
		&& ( ! $full_post_loading || (int)faithful_get_theme_option( 'open_full_post_hide_related', 1 ) == 0 )
	) {
		do_action( 'faithful_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $faithful_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $faithful_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $faithful_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $faithful_prev_post ) ); ?>"
			data-cur-post-link="<?php echo esc_attr( get_permalink() ); ?>"
			data-cur-post-title="<?php the_title_attribute(); ?>"
			<?php do_action( 'faithful_action_nav_links_single_scroll_data', $faithful_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
