<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.0
 */

if ( faithful_sidebar_present() ) {
	
	$faithful_sidebar_type = faithful_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $faithful_sidebar_type && ! faithful_is_layouts_available() ) {
		$faithful_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $faithful_sidebar_type ) {
		// Default sidebar with widgets
		$faithful_sidebar_name = faithful_get_theme_option( 'sidebar_widgets' );
		faithful_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $faithful_sidebar_name ) ) {
			dynamic_sidebar( $faithful_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$faithful_sidebar_id = faithful_get_custom_sidebar_id();
		do_action( 'faithful_action_show_layout', $faithful_sidebar_id );
	}
	$faithful_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $faithful_out ) ) {
		$faithful_sidebar_position    = faithful_get_theme_option( 'sidebar_position' );
		$faithful_sidebar_position_ss = faithful_get_theme_option( 'sidebar_position_ss', 'below' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $faithful_sidebar_position );
			echo ' sidebar_' . esc_attr( $faithful_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $faithful_sidebar_type );

			$faithful_sidebar_scheme = apply_filters( 'faithful_filter_sidebar_scheme', faithful_get_theme_option( 'sidebar_scheme', 'inherit' ) );
			if ( ! empty( $faithful_sidebar_scheme ) && ! faithful_is_inherit( $faithful_sidebar_scheme ) && 'custom' != $faithful_sidebar_type ) {
				echo ' scheme_' . esc_attr( $faithful_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<span id="sidebar_skip_link_anchor" class="faithful_skip_link_anchor"></span>
			<?php

			do_action( 'faithful_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $faithful_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$faithful_title = apply_filters( 'faithful_filter_sidebar_control_title', 'float' == $faithful_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'faithful' ) : '' );
				$faithful_text  = apply_filters( 'faithful_filter_sidebar_control_text', 'above' == $faithful_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'faithful' ) : '' );
				?>
				<a href="#" role="button" class="sidebar_control" title="<?php echo esc_attr( $faithful_title ); ?>"><?php echo esc_html( $faithful_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'faithful_action_before_sidebar', 'sidebar' );
				faithful_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $faithful_out ) );
				do_action( 'faithful_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'faithful_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
