<?php
/**
 * The template to display the attachment
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.0
 */


get_header();

while ( have_posts() ) {
	the_post();

	// Display post's content
	get_template_part( apply_filters( 'faithful_filter_get_template_part', 'templates/content', 'single-' . faithful_get_theme_option( 'single_style' ) ), 'single-' . faithful_get_theme_option( 'single_style' ) );

	// Parent post navigation.
	$faithful_posts_navigation = faithful_get_theme_option( 'posts_navigation' );
	if ( 'links' == $faithful_posts_navigation ) {
		?>
		<div class="nav-links-single<?php
			if ( ! faithful_is_off( faithful_get_theme_option( 'posts_navigation_fixed', 0 ) ) ) {
				echo ' nav-links-fixed fixed';
			}
		?>">
			<?php
			the_post_navigation( apply_filters( 'faithful_filter_post_navigation_args', array(
					'prev_text' => '<span class="nav-arrow"></span>'
						. '<span class="meta-nav" aria-hidden="true">' . esc_html__( 'Published in', 'faithful' ) . '</span> '
						. '<span class="screen-reader-text">' . esc_html__( 'Previous post:', 'faithful' ) . '</span> '
						. '<h5 class="post-title">%title</h5>'
						. '<span class="post_date">%date</span>',
			), 'image' ) );
			?>
		</div>
		<?php
	}

	// Comments
	do_action( 'faithful_action_before_comments' );
	comments_template();
	do_action( 'faithful_action_after_comments' );
}

get_footer();
