<?php
/**
 * The Header: Logo and main menu
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( faithful_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'faithful_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'faithful_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('faithful_action_body_wrap_attributes'); ?>>

		<?php do_action( 'faithful_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'faithful_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('faithful_action_page_wrap_attributes'); ?>>

			<?php do_action( 'faithful_action_page_wrap_start' ); ?>

			<?php
			$faithful_full_post_loading = ( faithful_is_singular( 'post' ) || faithful_is_singular( 'attachment' ) ) && faithful_get_value_gp( 'action' ) == 'full_post_loading';
			$faithful_prev_post_loading = ( faithful_is_singular( 'post' ) || faithful_is_singular( 'attachment' ) ) && faithful_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $faithful_full_post_loading && ! $faithful_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="faithful_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'faithful_filter_skip_links_tabindex', 0 ) ); ?>"><?php esc_html_e( "Skip to content", 'faithful' ); ?></a>
				<?php if ( faithful_sidebar_present() ) { ?>
				<a class="faithful_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'faithful_filter_skip_links_tabindex', 0 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'faithful' ); ?></a>
				<?php } ?>
				<a class="faithful_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'faithful_filter_skip_links_tabindex', 0 ) ); ?>"><?php esc_html_e( "Skip to footer", 'faithful' ); ?></a>

				<?php
				do_action( 'faithful_action_before_header' );

				// Header
				$faithful_header_type = faithful_get_theme_option( 'header_type' );
				if ( 'custom' == $faithful_header_type && ! faithful_is_layouts_available() ) {
					$faithful_header_type = 'default';
				}
				get_template_part( apply_filters( 'faithful_filter_get_template_part', "templates/header-" . sanitize_file_name( $faithful_header_type ) ) );

				// Side menu
				if ( in_array( faithful_get_theme_option( 'menu_side', 'none' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'faithful_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				if ( apply_filters( 'faithful_filter_use_navi_mobile', faithful_sc_layouts_showed( 'menu_button' ) || $faithful_header_type == 'default' ) ) {
					get_template_part( apply_filters( 'faithful_filter_get_template_part', 'templates/header-navi-mobile' ) );
				}

				do_action( 'faithful_action_after_header' );

			}
			?>

			<?php do_action( 'faithful_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( faithful_is_off( faithful_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $faithful_header_type ) ) {
						$faithful_header_type = faithful_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $faithful_header_type && faithful_is_layouts_available() ) {
						$faithful_header_id = faithful_get_custom_header_id();
						if ( $faithful_header_id > 0 ) {
							$faithful_header_meta = faithful_get_custom_layout_meta( $faithful_header_id );
							if ( ! empty( $faithful_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$faithful_footer_type = faithful_get_theme_option( 'footer_type' );
					if ( 'custom' == $faithful_footer_type && faithful_is_layouts_available() ) {
						$faithful_footer_id = faithful_get_custom_footer_id();
						if ( $faithful_footer_id ) {
							$faithful_footer_meta = faithful_get_custom_layout_meta( $faithful_footer_id );
							if ( ! empty( $faithful_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'faithful_action_page_content_wrap_class', $faithful_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'faithful_filter_is_prev_post_loading', $faithful_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( faithful_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'faithful_action_page_content_wrap_data', $faithful_prev_post_loading );
			?>>
				<?php
				do_action( 'faithful_action_page_content_wrap', $faithful_full_post_loading || $faithful_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'faithful_filter_single_post_header', faithful_is_singular( 'post' ) || faithful_is_singular( 'attachment' ) ) ) {
					if ( $faithful_prev_post_loading ) {
						if ( faithful_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) != 'article' ) {
							do_action( 'faithful_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$faithful_path = apply_filters( 'faithful_filter_get_template_part', 'templates/single-styles/' . faithful_get_theme_option( 'single_style' ) );
					if ( faithful_get_file_dir( $faithful_path . '.php' ) != '' ) {
						get_template_part( $faithful_path );
					}
				}

				// Widgets area above page
				$faithful_body_style   = faithful_get_theme_option( 'body_style' );
				$faithful_widgets_name = faithful_get_theme_option( 'widgets_above_page', 'hide' );
				$faithful_show_widgets = ! faithful_is_off( $faithful_widgets_name ) && is_active_sidebar( $faithful_widgets_name );
				if ( $faithful_show_widgets ) {
					if ( 'fullscreen' != $faithful_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					faithful_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $faithful_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'faithful_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $faithful_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'faithful_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'faithful_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<span id="content_skip_link_anchor" class="faithful_skip_link_anchor"></span>
						<?php
						// Single posts banner between prev/next posts
						if ( ( faithful_is_singular( 'post' ) || faithful_is_singular( 'attachment' ) )
							&& $faithful_prev_post_loading 
							&& faithful_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) == 'article'
						) {
							do_action( 'faithful_action_between_posts' );
						}

						// Widgets area above content
						faithful_create_widgets_area( 'widgets_above_content' );

						do_action( 'faithful_action_page_content_start_text' );
