<?php
$faithful_woocommerce_sc = faithful_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $faithful_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$faithful_scheme = faithful_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $faithful_scheme ) && ! faithful_is_inherit( $faithful_scheme ) ) {
			echo ' scheme_' . esc_attr( $faithful_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( faithful_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( faithful_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$faithful_css      = '';
			$faithful_bg_image = faithful_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $faithful_bg_image ) ) {
				$faithful_css .= 'background-image: url(' . esc_url( faithful_get_attachment_url( $faithful_bg_image ) ) . ');';
			}
			if ( ! empty( $faithful_css ) ) {
				echo ' style="' . esc_attr( $faithful_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$faithful_anchor_icon = faithful_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$faithful_anchor_text = faithful_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $faithful_anchor_icon ) || ! empty( $faithful_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $faithful_anchor_icon ) ? ' icon="' . esc_attr( $faithful_anchor_icon ) . '"' : '' )
											. ( ! empty( $faithful_anchor_text ) ? ' title="' . esc_attr( $faithful_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( faithful_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' faithful-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$faithful_css      = '';
				$faithful_bg_mask  = faithful_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$faithful_bg_color_type = faithful_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $faithful_bg_color_type ) {
					$faithful_bg_color = faithful_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $faithful_bg_color_type ) {
					$faithful_bg_color = faithful_get_scheme_color( 'bg_color', $faithful_scheme );
				} else {
					$faithful_bg_color = '';
				}
				if ( ! empty( $faithful_bg_color ) && $faithful_bg_mask > 0 ) {
					$faithful_css .= 'background-color: ' . esc_attr(
						1 == $faithful_bg_mask ? $faithful_bg_color : faithful_hex2rgba( $faithful_bg_color, $faithful_bg_mask )
					) . ';';
				}
				if ( ! empty( $faithful_css ) ) {
					echo ' style="' . esc_attr( $faithful_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$faithful_caption     = faithful_get_theme_option( 'front_page_woocommerce_caption' );
				$faithful_description = faithful_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $faithful_caption ) || ! empty( $faithful_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $faithful_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $faithful_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $faithful_caption, 'faithful_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $faithful_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $faithful_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $faithful_description ), 'faithful_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $faithful_woocommerce_sc ) {
						$faithful_woocommerce_sc_ids      = faithful_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$faithful_woocommerce_sc_per_page = count( explode( ',', $faithful_woocommerce_sc_ids ) );
					} else {
						$faithful_woocommerce_sc_per_page = max( 1, (int) faithful_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$faithful_woocommerce_sc_columns = max( 1, min( $faithful_woocommerce_sc_per_page, (int) faithful_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$faithful_woocommerce_sc}"
										. ( 'products' == $faithful_woocommerce_sc
												? ' ids="' . esc_attr( $faithful_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $faithful_woocommerce_sc
												? ' category="' . esc_attr( faithful_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $faithful_woocommerce_sc
												? ' orderby="' . esc_attr( faithful_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( faithful_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $faithful_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $faithful_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
