<div class="front_page_section front_page_section_googlemap<?php
	$faithful_scheme = faithful_get_theme_option( 'front_page_googlemap_scheme' );
	if ( ! empty( $faithful_scheme ) && ! faithful_is_inherit( $faithful_scheme ) ) {
		echo ' scheme_' . esc_attr( $faithful_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( faithful_get_theme_option( 'front_page_googlemap_paddings' ) );
	if ( faithful_get_theme_option( 'front_page_googlemap_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$faithful_css      = '';
		$faithful_bg_image = faithful_get_theme_option( 'front_page_googlemap_bg_image' );
		if ( ! empty( $faithful_bg_image ) ) {
			$faithful_css .= 'background-image: url(' . esc_url( faithful_get_attachment_url( $faithful_bg_image ) ) . ');';
		}
		if ( ! empty( $faithful_css ) ) {
			echo ' style="' . esc_attr( $faithful_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$faithful_anchor_icon = faithful_get_theme_option( 'front_page_googlemap_anchor_icon' );
	$faithful_anchor_text = faithful_get_theme_option( 'front_page_googlemap_anchor_text' );
if ( ( ! empty( $faithful_anchor_icon ) || ! empty( $faithful_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_googlemap"'
									. ( ! empty( $faithful_anchor_icon ) ? ' icon="' . esc_attr( $faithful_anchor_icon ) . '"' : '' )
									. ( ! empty( $faithful_anchor_text ) ? ' title="' . esc_attr( $faithful_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_googlemap_inner
		<?php
		$faithful_layout = faithful_get_theme_option( 'front_page_googlemap_layout' );
		echo ' front_page_section_layout_' . esc_attr( $faithful_layout );
		if ( faithful_get_theme_option( 'front_page_googlemap_fullheight' ) ) {
			echo ' faithful-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
		"
			<?php
			$faithful_css      = '';
			$faithful_bg_mask  = faithful_get_theme_option( 'front_page_googlemap_bg_mask' );
			$faithful_bg_color_type = faithful_get_theme_option( 'front_page_googlemap_bg_color_type' );
			if ( 'custom' == $faithful_bg_color_type ) {
				$faithful_bg_color = faithful_get_theme_option( 'front_page_googlemap_bg_color' );
			} elseif ( 'scheme_bg_color' == $faithful_bg_color_type ) {
				$faithful_bg_color = faithful_get_scheme_color( 'bg_color', $faithful_scheme );
			} else {
				$faithful_bg_color = '';
			}
			if ( ! empty( $faithful_bg_color ) && $faithful_bg_mask > 0 ) {
				$faithful_css .= 'background-color: ' . esc_attr(
					1 == $faithful_bg_mask ? $faithful_bg_color : faithful_hex2rgba( $faithful_bg_color, $faithful_bg_mask )
				) . ';';
			}
			if ( ! empty( $faithful_css ) ) {
				echo ' style="' . esc_attr( $faithful_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_googlemap_content_wrap
		<?php
		if ( 'fullwidth' != $faithful_layout ) {
			echo ' content_wrap';
		}
		?>
		">
			<?php
			// Content wrap with title and description
			$faithful_caption     = faithful_get_theme_option( 'front_page_googlemap_caption' );
			$faithful_description = faithful_get_theme_option( 'front_page_googlemap_description' );
			if ( ! empty( $faithful_caption ) || ! empty( $faithful_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				if ( 'fullwidth' == $faithful_layout ) {
					?>
					<div class="content_wrap">
					<?php
				}
					// Caption
				if ( ! empty( $faithful_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_googlemap_caption front_page_block_<?php echo ! empty( $faithful_caption ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $faithful_caption, 'faithful_kses_content' );
					?>
					</h2>
					<?php
				}

					// Description (text)
				if ( ! empty( $faithful_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_googlemap_description front_page_block_<?php echo ! empty( $faithful_description ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( wpautop( $faithful_description ), 'faithful_kses_content' );
					?>
					</div>
					<?php
				}
				if ( 'fullwidth' == $faithful_layout ) {
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$faithful_content = faithful_get_theme_option( 'front_page_googlemap_content' );
			if ( ! empty( $faithful_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				if ( 'columns' == $faithful_layout ) {
					?>
					<div class="front_page_section_columns front_page_section_googlemap_columns columns_wrap">
						<div class="column-1_3">
					<?php
				} elseif ( 'fullwidth' == $faithful_layout ) {
					?>
					<div class="content_wrap">
					<?php
				}

				?>
				<div class="front_page_section_content front_page_section_googlemap_content front_page_block_<?php echo ! empty( $faithful_content ) ? 'filled' : 'empty'; ?>">
				<?php
					echo wp_kses( $faithful_content, 'faithful_kses_content' );
				?>
				</div>
				<?php

				if ( 'columns' == $faithful_layout ) {
					?>
					</div><div class="column-2_3">
					<?php
				} elseif ( 'fullwidth' == $faithful_layout ) {
					?>
					</div>
					<?php
				}
			}

			// Widgets output
			?>
			<div class="front_page_section_output front_page_section_googlemap_output">
				<?php
				if ( is_active_sidebar( 'front_page_googlemap_widgets' ) ) {
					dynamic_sidebar( 'front_page_googlemap_widgets' );
				} elseif ( current_user_can( 'edit_theme_options' ) ) {
					if ( ! faithful_exists_trx_addons() ) {
						faithful_customizer_need_trx_addons_message();
					} else {
						faithful_customizer_need_widgets_message( 'front_page_googlemap_caption', 'ThemeREX Addons - Google map' );
					}
				}
				?>
			</div>
			<?php

			if ( 'columns' == $faithful_layout && ( ! empty( $faithful_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>
		</div>
	</div>
</div>
