<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package FAITHFUL
 * @since FAITHFUL 1.0
 */

							do_action( 'faithful_action_page_content_end_text' );
							
							// Widgets area below the content
							faithful_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'faithful_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'faithful_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'faithful_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'faithful_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$faithful_body_style = faithful_get_theme_option( 'body_style' );
					$faithful_widgets_name = faithful_get_theme_option( 'widgets_below_page', 'hide' );
					$faithful_show_widgets = ! faithful_is_off( $faithful_widgets_name ) && is_active_sidebar( $faithful_widgets_name );
					$faithful_show_related = faithful_is_single() && faithful_get_theme_option( 'related_position', 'below_content' ) == 'below_page';
					if ( $faithful_show_widgets || $faithful_show_related ) {
						if ( 'fullscreen' != $faithful_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $faithful_show_related ) {
							do_action( 'faithful_action_related_posts' );
						}

						// Widgets area below page content
						if ( $faithful_show_widgets ) {
							faithful_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $faithful_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'faithful_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'faithful_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! faithful_is_singular( 'post' ) && ! faithful_is_singular( 'attachment' ) ) || ! in_array ( faithful_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<span id="footer_skip_link_anchor" class="faithful_skip_link_anchor"></span>
				<?php

				do_action( 'faithful_action_before_footer' );

				// Footer
				$faithful_footer_type = faithful_get_theme_option( 'footer_type' );
				if ( 'custom' == $faithful_footer_type && ! faithful_is_layouts_available() ) {
					$faithful_footer_type = 'default';
				}
				get_template_part( apply_filters( 'faithful_filter_get_template_part', "templates/footer-" . sanitize_file_name( $faithful_footer_type ) ) );

				do_action( 'faithful_action_after_footer' );

			}
			?>

			<?php do_action( 'faithful_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'faithful_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'faithful_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>