import {Path, SVG} from '@wordpress/components';

export function LockIcon() {
    return (
        <SVG width="14" height="16" viewBox="0 0 14 16" fill="none" xmlns="http://www.w3.org/2000/svg">
            <Path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M7.00001 0C6.31001 0 5.15701 0.265 4.07201 0.56C2.96201 0.86 1.84301 1.215 1.18501 1.43C0.909897 1.52085 0.665996 1.68747 0.481322 1.9107C0.296648 2.13394 0.178693 2.40474 0.141005 2.692C-0.454995 7.169 0.928005 10.487 2.60601 12.682C3.31759 13.621 4.16603 14.4478 5.12301 15.135C5.50901 15.408 5.86701 15.617 6.17101 15.76C6.45101 15.892 6.75201 16 7.00001 16C7.24801 16 7.54801 15.892 7.82901 15.76C8.19549 15.5819 8.5461 15.3728 8.87701 15.135C9.834 14.4479 10.6824 13.621 11.394 12.682C13.072 10.487 14.455 7.169 13.859 2.692C13.8214 2.4046 13.7035 2.13364 13.5188 1.91023C13.3341 1.68683 13.0902 1.52003 12.815 1.429C11.8598 1.11581 10.8972 0.825729 9.92801 0.559C8.84301 0.266 7.69001 0 7.00001 0ZM7.00001 5C7.35424 4.99947 7.69724 5.12433 7.96824 5.35246C8.23924 5.58059 8.42076 5.89727 8.48065 6.24641C8.54054 6.59555 8.47493 6.95462 8.29544 7.26002C8.11595 7.56542 7.83417 7.79745 7.50001 7.915L7.88501 9.905C7.89901 9.97738 7.89684 10.052 7.87865 10.1234C7.86045 10.1948 7.82668 10.2614 7.77976 10.3182C7.73284 10.3751 7.67392 10.4209 7.60723 10.4523C7.54054 10.4837 7.46773 10.5 7.39401 10.5H6.60601C6.53237 10.4999 6.45967 10.4835 6.3931 10.452C6.32653 10.4205 6.26774 10.3747 6.22093 10.3179C6.17412 10.261 6.14044 10.1945 6.1223 10.1232C6.10416 10.0518 6.10201 9.9773 6.11601 9.905L6.50001 7.915C6.16584 7.79745 5.88406 7.56542 5.70457 7.26002C5.52508 6.95462 5.45947 6.59555 5.51936 6.24641C5.57925 5.89727 5.76077 5.58059 6.03177 5.35246C6.30277 5.12433 6.64577 4.99947 7.00001 5Z"
                fill="#A6A6A6"
            />
        </SVG>
    );
}

export default function LockedFieldBlocks() {
    return (
        <SVG width="288" height="282" viewBox="0 0 288 282" fill="none" xmlns="http://www.w3.org/2000/SVG">
            <Path
                d="M53 27H56L54.5 29L53 27ZM39 24H57C57.5304 24 58.0391 24.2107 58.4142 24.5858C58.7893 24.9609 59 25.4696 59 26V30C59 31.11 58.11 32 57 32H52V42C52 43.11 51.11 44 50 44H39C38.4696 44 37.9609 43.7893 37.5858 43.4142C37.2107 43.0391 37 42.5304 37 42V26C37 24.9 37.9 24 39 24ZM39 26V30H50V26H39ZM57 30V26H52V30H57ZM39 42H50V32H39V42ZM41 34H48V36H41V34ZM41 38H48V40H41V38Z"
                fill="#A6A6A6"
            />
            <Path
                d="M20.0508 68V59.5449H22.9512C25.459 59.5449 26.9414 61.1094 26.9414 63.7637V63.7754C26.9414 66.4355 25.4648 68 22.9512 68H20.0508ZM21.1055 67.0508H22.8809C24.7676 67.0508 25.8633 65.8438 25.8633 63.7871V63.7754C25.8633 61.7129 24.7559 60.4941 22.8809 60.4941H21.1055V67.0508ZM28.6406 68V61.6836H29.6602V62.6211H29.7539C29.9941 61.959 30.5859 61.5723 31.4414 61.5723C31.6348 61.5723 31.8516 61.5957 31.9512 61.6133V62.6035C31.7402 62.5684 31.5469 62.5449 31.3242 62.5449C30.3516 62.5449 29.6602 63.1602 29.6602 64.0859V68H28.6406ZM35.6309 68.1113C33.832 68.1113 32.7188 66.8691 32.7188 64.8477V64.8359C32.7188 62.8086 33.832 61.5723 35.6309 61.5723C37.4297 61.5723 38.543 62.8086 38.543 64.8359V64.8477C38.543 66.8691 37.4297 68.1113 35.6309 68.1113ZM35.6309 67.209C36.8262 67.209 37.5 66.3359 37.5 64.8477V64.8359C37.5 63.3418 36.8262 62.4746 35.6309 62.4746C34.4355 62.4746 33.7617 63.3418 33.7617 64.8359V64.8477C33.7617 66.3359 34.4355 67.209 35.6309 67.209ZM40.125 70.1094V61.6836H41.1445V62.6914H41.2383C41.625 61.9883 42.3281 61.5723 43.207 61.5723C44.8066 61.5723 45.8555 62.8672 45.8555 64.8359V64.8477C45.8555 66.8281 44.8125 68.1113 43.207 68.1113C42.3398 68.1113 41.584 67.6777 41.2383 67.0039H41.1445V70.1094H40.125ZM42.9727 67.209C44.127 67.209 44.8125 66.3184 44.8125 64.8477V64.8359C44.8125 63.3652 44.127 62.4746 42.9727 62.4746C41.8242 62.4746 41.1211 63.377 41.1211 64.8359V64.8477C41.1211 66.3066 41.8242 67.209 42.9727 67.209ZM49.7812 68.1113C48.1816 68.1113 47.1328 66.8164 47.1328 64.8477V64.8359C47.1328 62.8555 48.1758 61.5723 49.7812 61.5723C50.6484 61.5723 51.4043 62.0059 51.75 62.6797H51.8438V59.1758H52.8633V68H51.8438V66.9922H51.75C51.3633 67.6953 50.6602 68.1113 49.7812 68.1113ZM50.0156 67.209C51.1641 67.209 51.8672 66.3066 51.8672 64.8477V64.8359C51.8672 63.377 51.1641 62.4746 50.0156 62.4746C48.8613 62.4746 48.1758 63.3652 48.1758 64.8359V64.8477C48.1758 66.3184 48.8613 67.209 50.0156 67.209ZM57.416 68.1113C55.6172 68.1113 54.5039 66.8691 54.5039 64.8477V64.8359C54.5039 62.8086 55.6172 61.5723 57.416 61.5723C59.2148 61.5723 60.3281 62.8086 60.3281 64.8359V64.8477C60.3281 66.8691 59.2148 68.1113 57.416 68.1113ZM57.416 67.209C58.6113 67.209 59.2852 66.3359 59.2852 64.8477V64.8359C59.2852 63.3418 58.6113 62.4746 57.416 62.4746C56.2207 62.4746 55.5469 63.3418 55.5469 64.8359V64.8477C55.5469 66.3359 56.2207 67.209 57.416 67.209ZM62.8945 68L61.125 61.6836H62.1445L63.3867 66.7344H63.4805L64.8926 61.6836H65.8594L67.2715 66.7344H67.3652L68.6074 61.6836H69.6211L67.8516 68H66.8262L65.4141 63.1133H65.3203L63.9141 68H62.8945ZM70.9688 68V61.6836H71.9883V62.6328H72.082C72.3984 61.9648 72.9902 61.5723 73.9219 61.5723C75.3398 61.5723 76.1309 62.4102 76.1309 63.9102V68H75.1113V64.1562C75.1113 63.0195 74.6426 62.4746 73.6348 62.4746C72.627 62.4746 71.9883 63.1543 71.9883 64.2617V68H70.9688Z"
                fill="#A6A6A6"
            />
            <Path
                d="M153 34L141 34M153 28L141 28M153 40L141 40M137 34C137 34.5523 136.552 35 136 35C135.448 35 135 34.5523 135 34C135 33.4477 135.448 33 136 33C136.552 33 137 33.4477 137 34ZM137 28C137 28.5523 136.552 29 136 29C135.448 29 135 28.5523 135 28C135 27.4477 135.448 27 136 27C136.552 27 137 27.4477 137 28ZM137 40C137 40.5523 136.552 41 136 41C135.448 41 135 40.5523 135 40C135 39.4477 135.448 39 136 39C136.552 39 137 39.4477 137 40Z"
                stroke="#A6A6A6"
                strokeWidth="2"
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <Path
                d="M111.211 68V59.5449H112.436L115.33 66.5996H115.424L118.318 59.5449H119.543V68H118.559V61.543H118.494L115.822 68H114.932L112.26 61.543H112.195V68H111.211ZM123.686 68.1113C122.25 68.1113 121.512 67.2676 121.512 65.7734V61.6836H122.531V65.5273C122.531 66.6641 122.941 67.209 123.949 67.209C125.062 67.209 125.654 66.5293 125.654 65.4219V61.6836H126.674V68H125.654V67.0566H125.561C125.25 67.7305 124.611 68.1113 123.686 68.1113ZM128.637 68V59.1758H129.656V68H128.637ZM133.857 68.0469C132.557 68.0469 132.012 67.5664 132.012 66.3594V62.5273H131.016V61.6836H132.012V60.0488H133.066V61.6836H134.449V62.5273H133.066V66.1016C133.066 66.8457 133.324 67.1445 133.98 67.1445C134.162 67.1445 134.262 67.1387 134.449 67.1211V67.9883C134.25 68.0234 134.057 68.0469 133.857 68.0469ZM136.512 60.4648C136.125 60.4648 135.809 60.1484 135.809 59.7617C135.809 59.375 136.125 59.0586 136.512 59.0586C136.898 59.0586 137.215 59.375 137.215 59.7617C137.215 60.1484 136.898 60.4648 136.512 60.4648ZM135.996 68V61.6836H137.016V68H135.996ZM138.85 65.0703V64.1211H142.787V65.0703H138.85ZM146.766 68.1113C145.359 68.1113 144.393 67.4316 144.275 66.3887H145.318C145.488 66.916 145.992 67.2617 146.801 67.2617C147.65 67.2617 148.254 66.8574 148.254 66.2832V66.2715C148.254 65.8438 147.932 65.5449 147.152 65.3574L146.174 65.123C144.99 64.8418 144.457 64.3262 144.457 63.418V63.4121C144.457 62.3633 145.465 61.5723 146.807 61.5723C148.131 61.5723 149.051 62.2344 149.191 63.2656H148.189C148.055 62.7676 147.562 62.4219 146.801 62.4219C146.051 62.4219 145.5 62.8086 145.5 63.3652V63.377C145.5 63.8047 145.816 64.0742 146.561 64.2559L147.533 64.4902C148.723 64.7773 149.297 65.293 149.297 66.1953V66.207C149.297 67.332 148.201 68.1113 146.766 68.1113ZM153.457 68.1113C151.652 68.1113 150.562 66.8457 150.562 64.8652V64.8594C150.562 62.9082 151.676 61.5723 153.393 61.5723C155.109 61.5723 156.152 62.8496 156.152 64.7363V65.1348H151.605C151.635 66.4414 152.355 67.2031 153.48 67.2031C154.336 67.2031 154.863 66.7988 155.033 66.418L155.057 66.3652H156.076L156.064 66.4121C155.848 67.2676 154.945 68.1113 153.457 68.1113ZM153.387 62.4805C152.449 62.4805 151.734 63.1191 151.623 64.3203H155.115C155.01 63.0723 154.318 62.4805 153.387 62.4805ZM157.793 68V59.1758H158.812V68H157.793ZM163.348 68.1113C161.543 68.1113 160.453 66.8457 160.453 64.8652V64.8594C160.453 62.9082 161.566 61.5723 163.283 61.5723C165 61.5723 166.043 62.8496 166.043 64.7363V65.1348H161.496C161.525 66.4414 162.246 67.2031 163.371 67.2031C164.227 67.2031 164.754 66.7988 164.924 66.418L164.947 66.3652H165.967L165.955 66.4121C165.738 67.2676 164.836 68.1113 163.348 68.1113ZM163.277 62.4805C162.34 62.4805 161.625 63.1191 161.514 64.3203H165.006C164.9 63.0723 164.209 62.4805 163.277 62.4805ZM170.209 68.1113C168.439 68.1113 167.309 66.8281 167.309 64.8242V64.8125C167.309 62.8496 168.434 61.5723 170.203 61.5723C171.738 61.5723 172.658 62.457 172.846 63.582L172.852 63.6172H171.838L171.832 63.5996C171.674 62.9785 171.111 62.4746 170.203 62.4746C169.066 62.4746 168.352 63.3887 168.352 64.8125V64.8242C168.352 66.2773 169.078 67.209 170.203 67.209C171.053 67.209 171.592 66.834 171.826 66.1309L171.838 66.0957L172.846 66.0898L172.834 66.1543C172.576 67.2969 171.727 68.1113 170.209 68.1113ZM176.701 68.0469C175.4 68.0469 174.855 67.5664 174.855 66.3594V62.5273H173.859V61.6836H174.855V60.0488H175.91V61.6836H177.293V62.5273H175.91V66.1016C175.91 66.8457 176.168 67.1445 176.824 67.1445C177.006 67.1445 177.105 67.1387 177.293 67.1211V67.9883C177.094 68.0234 176.9 68.0469 176.701 68.0469Z"
                fill="#A6A6A6"
            />
            <Path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M244.056 43.8806C240.862 42.9743 237.85 41.2639 235.338 38.7523C232.826 36.2406 231.116 33.2277 230.21 30.0345C230.204 30.0156 230.199 29.9968 230.194 29.9782C230.046 29.4592 229.932 29.0567 229.93 28.5048C229.928 27.874 230.134 27.0838 230.443 26.5338C230.974 25.5881 232.115 24.376 233.1 23.8776C233.951 23.447 234.957 23.447 235.808 23.8776C236.65 24.3036 237.588 25.2572 238.111 26.0615C238.758 27.0558 238.758 28.3377 238.111 29.332C237.938 29.5985 237.691 29.845 237.404 30.1311C237.315 30.2203 237.217 30.2846 237.282 30.4205C237.93 31.7698 238.813 33.0354 239.934 34.1561C241.055 35.2768 242.32 36.1603 243.67 36.8081C243.81 36.8756 243.866 36.7792 243.959 36.6858C244.245 36.3991 244.492 36.1522 244.758 35.979C245.753 35.3325 247.034 35.3325 248.029 35.979C248.811 36.4879 249.79 37.4465 250.213 38.2821C250.643 39.1335 250.643 40.1389 250.213 40.9902C249.714 41.9755 248.502 43.1163 247.556 43.6476C247.006 43.9565 246.216 44.162 245.585 44.1601C245.034 44.1585 244.631 44.0441 244.112 43.8966C244.093 43.8913 244.075 43.886 244.056 43.8806Z"
                fill="#A6A6A6"
            />
            <Path
                d="M223.254 68V59.5449H226.441C228.029 59.5449 229.154 60.6406 229.154 62.2461V62.2578C229.154 63.8633 228.029 64.9824 226.441 64.9824H224.309V68H223.254ZM226.172 60.4824H224.309V64.0449H226.172C227.379 64.0449 228.076 63.3828 228.076 62.2695V62.2578C228.076 61.1445 227.379 60.4824 226.172 60.4824ZM230.812 68V59.1758H231.832V62.6328H231.926C232.242 61.9648 232.834 61.5723 233.766 61.5723C235.184 61.5723 235.975 62.4102 235.975 63.9102V68H234.955V64.1562C234.955 63.0195 234.486 62.4746 233.479 62.4746C232.471 62.4746 231.832 63.1543 231.832 64.2617V68H230.812ZM240.416 68.1113C238.617 68.1113 237.504 66.8691 237.504 64.8477V64.8359C237.504 62.8086 238.617 61.5723 240.416 61.5723C242.215 61.5723 243.328 62.8086 243.328 64.8359V64.8477C243.328 66.8691 242.215 68.1113 240.416 68.1113ZM240.416 67.209C241.611 67.209 242.285 66.3359 242.285 64.8477V64.8359C242.285 63.3418 241.611 62.4746 240.416 62.4746C239.221 62.4746 238.547 63.3418 238.547 64.8359V64.8477C238.547 66.3359 239.221 67.209 240.416 67.209ZM244.91 68V61.6836H245.93V62.6328H246.023C246.34 61.9648 246.932 61.5723 247.863 61.5723C249.281 61.5723 250.072 62.4102 250.072 63.9102V68H249.053V64.1562C249.053 63.0195 248.584 62.4746 247.576 62.4746C246.568 62.4746 245.93 63.1543 245.93 64.2617V68H244.91ZM254.496 68.1113C252.691 68.1113 251.602 66.8457 251.602 64.8652V64.8594C251.602 62.9082 252.715 61.5723 254.432 61.5723C256.148 61.5723 257.191 62.8496 257.191 64.7363V65.1348H252.645C252.674 66.4414 253.395 67.2031 254.52 67.2031C255.375 67.2031 255.902 66.7988 256.072 66.418L256.096 66.3652H257.115L257.104 66.4121C256.887 67.2676 255.984 68.1113 254.496 68.1113ZM254.426 62.4805C253.488 62.4805 252.773 63.1191 252.662 64.3203H256.154C256.049 63.0723 255.357 62.4805 254.426 62.4805Z"
                fill="#A6A6A6"
            />
            <Path
                d="M38 123L46.1649 128.715C46.8261 129.178 47.1567 129.41 47.5163 129.499C47.8339 129.578 48.1661 129.578 48.4837 129.499C48.8433 129.41 49.1739 129.178 49.8351 128.715L58 123M42.8 136H53.2C54.8802 136 55.7202 136 56.362 135.673C56.9265 135.385 57.3854 134.926 57.673 134.362C58 133.72 58 132.88 58 131.2V124.8C58 123.12 58 122.28 57.673 121.638C57.3854 121.074 56.9265 120.615 56.362 120.327C55.7202 120 54.8802 120 53.2 120H42.8C41.1198 120 40.2798 120 39.638 120.327C39.0735 120.615 38.6146 121.074 38.327 121.638C38 122.28 38 123.12 38 124.8V131.2C38 132.88 38 133.72 38.327 134.362C38.6146 134.926 39.0735 135.385 39.638 135.673C40.2798 136 41.1198 136 42.8 136Z"
                stroke="#A6A6A6"
                strokeWidth="2"
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <Path
                d="M33.9727 162V153.545H39.2109V154.494H35.0273V157.207H38.9941V158.145H35.0273V161.051H39.2109V162H33.9727ZM40.9922 162V155.684H42.0117V156.645H42.1055C42.3867 155.965 42.9844 155.572 43.8105 155.572C44.666 155.572 45.2637 156.023 45.5566 156.68H45.6504C45.9902 156.012 46.7109 155.572 47.584 155.572C48.873 155.572 49.5938 156.311 49.5938 157.635V162H48.5742V157.869C48.5742 156.938 48.1465 156.475 47.2559 156.475C46.377 156.475 45.7969 157.137 45.7969 157.939V162H44.7773V157.711C44.7773 156.961 44.2617 156.475 43.4648 156.475C42.6387 156.475 42.0117 157.195 42.0117 158.086V162H40.9922ZM53.168 162.111C51.9668 162.111 51.0586 161.385 51.0586 160.236V160.225C51.0586 159.1 51.8906 158.449 53.3613 158.361L55.1719 158.25V157.676C55.1719 156.896 54.6973 156.475 53.7539 156.475C52.998 156.475 52.5 156.756 52.3359 157.248L52.3301 157.266H51.3105L51.3164 157.23C51.4805 156.24 52.4414 155.572 53.7891 155.572C55.3301 155.572 56.1914 156.363 56.1914 157.676V162H55.1719V161.068H55.0781C54.6797 161.742 54.0176 162.111 53.168 162.111ZM52.1016 160.213C52.1016 160.852 52.6465 161.227 53.3789 161.227C54.416 161.227 55.1719 160.547 55.1719 159.645V159.07L53.4844 159.176C52.5234 159.234 52.1016 159.574 52.1016 160.201V160.213ZM58.5938 154.465C58.207 154.465 57.8906 154.148 57.8906 153.762C57.8906 153.375 58.207 153.059 58.5938 153.059C58.9805 153.059 59.2969 153.375 59.2969 153.762C59.2969 154.148 58.9805 154.465 58.5938 154.465ZM58.0781 162V155.684H59.0977V162H58.0781ZM61.0781 162V153.176H62.0977V162H61.0781Z"
                fill="#A6A6A6"
            />
            <Path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M149 118C149 117.448 148.552 117 148 117C147.448 117 147 117.448 147 118V119H141V118C141 117.448 140.552 117 140 117C139.448 117 139 117.448 139 118V119.002C138.525 119.005 138.109 119.015 137.748 119.044C137.186 119.09 136.669 119.189 136.184 119.436C135.431 119.819 134.819 120.431 134.436 121.184C134.189 121.669 134.09 122.186 134.044 122.748C134 123.289 134 123.954 134 124.759V133.241C134 134.046 134 134.711 134.044 135.252C134.09 135.814 134.189 136.331 134.436 136.816C134.819 137.569 135.431 138.181 136.184 138.564C136.669 138.811 137.186 138.91 137.748 138.956C138.289 139 138.954 139 139.759 139H148.241C149.046 139 149.711 139 150.252 138.956C150.814 138.91 151.331 138.811 151.816 138.564C152.569 138.181 153.181 137.569 153.564 136.816C153.811 136.331 153.91 135.814 153.956 135.252C154 134.711 154 134.046 154 133.241V124.759C154 123.954 154 123.289 153.956 122.748C153.91 122.186 153.811 121.669 153.564 121.184C153.181 120.431 152.569 119.819 151.816 119.436C151.331 119.189 150.814 119.09 150.252 119.044C149.891 119.015 149.475 119.005 149 119.002V118ZM139 122V121.002C138.554 121.005 138.205 121.014 137.911 121.038C137.473 121.073 137.248 121.138 137.092 121.218C136.716 121.41 136.41 121.716 136.218 122.092C136.138 122.248 136.073 122.473 136.038 122.911C136.001 123.361 136 123.943 136 124.8V125H152V124.8C152 123.943 151.999 123.361 151.962 122.911C151.927 122.473 151.862 122.248 151.782 122.092C151.59 121.716 151.284 121.41 150.908 121.218C150.752 121.138 150.527 121.073 150.089 121.038C149.795 121.014 149.446 121.005 149 121.002V122C149 122.552 148.552 123 148 123C147.448 123 147 122.552 147 122V121H141V122C141 122.552 140.552 123 140 123C139.448 123 139 122.552 139 122ZM144.472 128.118C144.797 128.292 145 128.631 145 129V133H145.25C145.802 133 146.25 133.448 146.25 134C146.25 134.552 145.802 135 145.25 135H142.75C142.198 135 141.75 134.552 141.75 134C141.75 133.448 142.198 133 142.75 133H143V130.866C142.547 131.128 141.962 130.996 141.668 130.555C141.362 130.095 141.486 129.474 141.945 129.168L143.445 128.168C143.752 127.963 144.147 127.944 144.472 128.118Z"
                fill="#A6A6A6"
            />
            <Path
                d="M131.848 162V153.545H134.748C137.256 153.545 138.738 155.109 138.738 157.764V157.775C138.738 160.436 137.262 162 134.748 162H131.848ZM132.902 161.051H134.678C136.564 161.051 137.66 159.844 137.66 157.787V157.775C137.66 155.713 136.553 154.494 134.678 154.494H132.902V161.051ZM142.172 162.111C140.971 162.111 140.062 161.385 140.062 160.236V160.225C140.062 159.1 140.895 158.449 142.365 158.361L144.176 158.25V157.676C144.176 156.896 143.701 156.475 142.758 156.475C142.002 156.475 141.504 156.756 141.34 157.248L141.334 157.266H140.314L140.32 157.23C140.484 156.24 141.445 155.572 142.793 155.572C144.334 155.572 145.195 156.363 145.195 157.676V162H144.176V161.068H144.082C143.684 161.742 143.021 162.111 142.172 162.111ZM141.105 160.213C141.105 160.852 141.65 161.227 142.383 161.227C143.42 161.227 144.176 160.547 144.176 159.645V159.07L142.488 159.176C141.527 159.234 141.105 159.574 141.105 160.201V160.213ZM149.303 162.047C148.002 162.047 147.457 161.566 147.457 160.359V156.527H146.461V155.684H147.457V154.049H148.512V155.684H149.895V156.527H148.512V160.102C148.512 160.846 148.77 161.145 149.426 161.145C149.607 161.145 149.707 161.139 149.895 161.121V161.988C149.695 162.023 149.502 162.047 149.303 162.047ZM153.902 162.111C152.098 162.111 151.008 160.846 151.008 158.865V158.859C151.008 156.908 152.121 155.572 153.838 155.572C155.555 155.572 156.598 156.85 156.598 158.736V159.135H152.051C152.08 160.441 152.801 161.203 153.926 161.203C154.781 161.203 155.309 160.799 155.479 160.418L155.502 160.365H156.521L156.51 160.412C156.293 161.268 155.391 162.111 153.902 162.111ZM153.832 156.48C152.895 156.48 152.18 157.119 152.068 158.32H155.561C155.455 157.072 154.764 156.48 153.832 156.48Z"
                fill="#A6A6A6"
            />
            <Path
                d="M247.41 123.41L242.58 118.58C242.21 118.21 241.7 118 241.17 118H234C232.9 118 232.01 118.9 232.01 120L232 136C232 137.1 232.89 138 233.99 138H246C247.1 138 248 137.1 248 136V124.83C248 124.3 247.79 123.79 247.41 123.41ZM242.8 131H241V134C241 134.55 240.55 135 240 135C239.45 135 239 134.55 239 134V131H237.21C236.76 131 236.54 130.46 236.86 130.15L239.66 127.36C239.86 127.17 240.17 127.17 240.37 127.36L243.16 130.15C243.46 130.46 243.24 131 242.8 131ZM242 125C241.45 125 241 124.55 241 124V119.5L246.5 125H242Z"
                fill="#A6A6A6"
            />
            <Path
                d="M210.305 162V153.545H215.438V154.494H211.359V157.4H215.104V158.338H211.359V162H210.305ZM217.582 154.465C217.195 154.465 216.879 154.148 216.879 153.762C216.879 153.375 217.195 153.059 217.582 153.059C217.969 153.059 218.285 153.375 218.285 153.762C218.285 154.148 217.969 154.465 217.582 154.465ZM217.066 162V155.684H218.086V162H217.066ZM220.066 162V153.176H221.086V162H220.066ZM225.621 162.111C223.816 162.111 222.727 160.846 222.727 158.865V158.859C222.727 156.908 223.84 155.572 225.557 155.572C227.273 155.572 228.316 156.85 228.316 158.736V159.135H223.77C223.799 160.441 224.52 161.203 225.645 161.203C226.5 161.203 227.027 160.799 227.197 160.418L227.221 160.365H228.24L228.229 160.412C228.012 161.268 227.109 162.111 225.621 162.111ZM225.551 156.48C224.613 156.48 223.898 157.119 223.787 158.32H227.279C227.174 157.072 226.482 156.48 225.551 156.48ZM235.389 162.111C233.953 162.111 233.215 161.268 233.215 159.773V155.684H234.234V159.527C234.234 160.664 234.645 161.209 235.652 161.209C236.766 161.209 237.357 160.529 237.357 159.422V155.684H238.377V162H237.357V161.057H237.264C236.953 161.73 236.314 162.111 235.389 162.111ZM240.281 164.109V155.684H241.301V156.691H241.395C241.781 155.988 242.484 155.572 243.363 155.572C244.963 155.572 246.012 156.867 246.012 158.836V158.848C246.012 160.828 244.969 162.111 243.363 162.111C242.496 162.111 241.74 161.678 241.395 161.004H241.301V164.109H240.281ZM243.129 161.209C244.283 161.209 244.969 160.318 244.969 158.848V158.836C244.969 157.365 244.283 156.475 243.129 156.475C241.98 156.475 241.277 157.377 241.277 158.836V158.848C241.277 160.307 241.98 161.209 243.129 161.209ZM247.664 162V153.176H248.684V162H247.664ZM253.236 162.111C251.438 162.111 250.324 160.869 250.324 158.848V158.836C250.324 156.809 251.438 155.572 253.236 155.572C255.035 155.572 256.148 156.809 256.148 158.836V158.848C256.148 160.869 255.035 162.111 253.236 162.111ZM253.236 161.209C254.432 161.209 255.105 160.336 255.105 158.848V158.836C255.105 157.342 254.432 156.475 253.236 156.475C252.041 156.475 251.367 157.342 251.367 158.836V158.848C251.367 160.336 252.041 161.209 253.236 161.209ZM259.465 162.111C258.264 162.111 257.355 161.385 257.355 160.236V160.225C257.355 159.1 258.188 158.449 259.658 158.361L261.469 158.25V157.676C261.469 156.896 260.994 156.475 260.051 156.475C259.295 156.475 258.797 156.756 258.633 157.248L258.627 157.266H257.607L257.613 157.23C257.777 156.24 258.738 155.572 260.086 155.572C261.627 155.572 262.488 156.363 262.488 157.676V162H261.469V161.068H261.375C260.977 161.742 260.314 162.111 259.465 162.111ZM258.398 160.213C258.398 160.852 258.943 161.227 259.676 161.227C260.713 161.227 261.469 160.547 261.469 159.645V159.07L259.781 159.176C258.82 159.234 258.398 159.574 258.398 160.201V160.213ZM266.684 162.111C265.084 162.111 264.035 160.816 264.035 158.848V158.836C264.035 156.855 265.078 155.572 266.684 155.572C267.551 155.572 268.307 156.006 268.652 156.68H268.746V153.176H269.766V162H268.746V160.992H268.652C268.266 161.695 267.562 162.111 266.684 162.111ZM266.918 161.209C268.066 161.209 268.77 160.307 268.77 158.848V158.836C268.77 157.377 268.066 156.475 266.918 156.475C265.764 156.475 265.078 157.365 265.078 158.836V158.848C265.078 160.318 265.764 161.209 266.918 161.209Z"
                fill="#A6A6A6"
            />
            <Path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M42 222C42 221.448 42.4477 221 43 221L53 221C53.5523 221 54 221.448 54 222C54 222.552 53.5523 223 53 223L43 223C42.4477 223 42 222.552 42 222Z"
                fill="#A6A6A6"
            />
            <Path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M43 218C40.7909 218 39 219.791 39 222C39 224.209 40.7909 226 43 226H45C45.5523 226 46 226.448 46 227C46 227.552 45.5523 228 45 228H43C39.6863 228 37 225.314 37 222C37 218.686 39.6863 216 43 216H45C45.5523 216 46 216.448 46 217C46 217.552 45.5523 218 45 218H43Z"
                fill="#A6A6A6"
            />
            <Path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M50 217C50 216.448 50.4477 216 51 216H53C56.3137 216 59 218.686 59 222C59 225.314 56.3137 228 53 228H51C50.4477 228 50 227.552 50 227C50 226.448 50.4477 226 51 226H53C55.2091 226 57 224.209 57 222C57 219.791 55.2091 218 53 218H51C50.4477 218 50 217.552 50 217Z"
                fill="#A6A6A6"
            />
            <Path
                d="M40.6758 256.199C38.5781 256.199 37.3125 254.934 37.3125 253.094V247.545H38.3672V253.023C38.3672 254.324 39.2109 255.227 40.6758 255.227C42.1406 255.227 42.9727 254.324 42.9727 253.023V247.545H44.0273V253.094C44.0273 254.934 42.7734 256.199 40.6758 256.199ZM46.1719 256V247.545H49.4004C51.0293 247.545 52.0957 248.541 52.0957 250.059V250.07C52.0957 251.242 51.457 252.156 50.3965 252.49L52.3535 256H51.1172L49.3066 252.654H47.2266V256H46.1719ZM47.2266 251.717H49.3066C50.3906 251.717 51.0059 251.137 51.0059 250.105V250.094C51.0059 249.086 50.3496 248.482 49.2598 248.482H47.2266V251.717ZM54.0117 256V247.545H55.0664V255.051H59.1445V256H54.0117Z"
                fill="#A6A6A6"
            />
            <Path
                d="M149 227L154 222L149 217M139 217L134 222L139 227M146 213L142 231"
                stroke="#A6A6A6"
                strokeWidth="2"
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <Path
                d="M128.168 256V247.545H129.223V251.201H133.863V247.545H134.918V256H133.863V252.15H129.223V256H128.168ZM139.271 256V248.494H136.547V247.545H143.051V248.494H140.326V256H139.271ZM144.68 256V247.545H145.904L148.799 254.6H148.893L151.787 247.545H153.012V256H152.027V249.543H151.963L149.291 256H148.4L145.729 249.543H145.664V256H144.68ZM155.168 256V247.545H156.223V255.051H160.301V256H155.168Z"
                fill="#A6A6A6"
            />
            <Path
                opacity="0.12"
                d="M237 222C237 223.657 238.343 225 240 225C240.828 225 241.578 224.664 242.121 224.122L237.879 219.879C237.336 220.422 237 221.172 237 222Z"
                fill="#A6A6A6"
            />
            <Path
                d="M238.743 215.092C239.149 215.032 239.568 215 240 215C245.105 215 248.455 219.505 249.58 221.287C249.717 221.503 249.785 221.61 249.823 221.777C249.851 221.902 249.851 222.099 249.823 222.224C249.785 222.39 249.716 222.498 249.579 222.716C249.279 223.19 248.822 223.857 248.216 224.58M234.724 216.715C232.562 218.182 231.094 220.219 230.421 221.285C230.284 221.502 230.216 221.61 230.177 221.776C230.149 221.901 230.149 222.098 230.177 222.223C230.215 222.39 230.284 222.498 230.42 222.713C231.545 224.495 234.895 229 240 229C242.058 229 243.832 228.268 245.288 227.277M231 213L249 231M237.879 219.879C237.336 220.422 237 221.172 237 222C237 223.657 238.343 225 240 225C240.828 225 241.578 224.664 242.121 224.121"
                stroke="#A6A6A6"
                strokeWidth="2"
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <Path
                d="M220.84 256V247.545H221.895V251.201H226.535V247.545H227.59V256H226.535V252.15H221.895V256H220.84ZM230.156 248.465C229.77 248.465 229.453 248.148 229.453 247.762C229.453 247.375 229.77 247.059 230.156 247.059C230.543 247.059 230.859 247.375 230.859 247.762C230.859 248.148 230.543 248.465 230.156 248.465ZM229.641 256V249.684H230.66V256H229.641ZM234.914 256.111C233.314 256.111 232.266 254.816 232.266 252.848V252.836C232.266 250.855 233.309 249.572 234.914 249.572C235.781 249.572 236.537 250.006 236.883 250.68H236.977V247.176H237.996V256H236.977V254.992H236.883C236.496 255.695 235.793 256.111 234.914 256.111ZM235.148 255.209C236.297 255.209 237 254.307 237 252.848V252.836C237 251.377 236.297 250.475 235.148 250.475C233.994 250.475 233.309 251.365 233.309 252.836V252.848C233.309 254.318 233.994 255.209 235.148 255.209ZM242.285 256.111C240.686 256.111 239.637 254.816 239.637 252.848V252.836C239.637 250.855 240.68 249.572 242.285 249.572C243.152 249.572 243.908 250.006 244.254 250.68H244.348V247.176H245.367V256H244.348V254.992H244.254C243.867 255.695 243.164 256.111 242.285 256.111ZM242.52 255.209C243.668 255.209 244.371 254.307 244.371 252.848V252.836C244.371 251.377 243.668 250.475 242.52 250.475C241.365 250.475 240.68 251.365 240.68 252.836V252.848C240.68 254.318 241.365 255.209 242.52 255.209ZM249.902 256.111C248.098 256.111 247.008 254.846 247.008 252.865V252.859C247.008 250.908 248.121 249.572 249.838 249.572C251.555 249.572 252.598 250.85 252.598 252.736V253.135H248.051C248.08 254.441 248.801 255.203 249.926 255.203C250.781 255.203 251.309 254.799 251.479 254.418L251.502 254.365H252.521L252.51 254.412C252.293 255.268 251.391 256.111 249.902 256.111ZM249.832 250.48C248.895 250.48 248.18 251.119 248.068 252.32H251.561C251.455 251.072 250.764 250.48 249.832 250.48ZM254.18 256V249.684H255.199V250.633H255.293C255.609 249.965 256.201 249.572 257.133 249.572C258.551 249.572 259.342 250.41 259.342 251.91V256H258.322V252.156C258.322 251.02 257.854 250.475 256.846 250.475C255.838 250.475 255.199 251.154 255.199 252.262V256H254.18Z"
                fill="#A6A6A6"
            />
        </SVG>
    );
}
